/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.fluid.transfer;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.util.CraftingHelper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.data.GenericRegisteredSerializer;
import slimeknights.mantle.fluid.transfer.FluidContainerTransferPacket;
import slimeknights.mantle.fluid.transfer.IFluidContainerTransfer;
import slimeknights.mantle.network.MantleNetwork;
import slimeknights.mantle.util.JsonHelper;

public class FluidContainerTransferManager
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Logger log = LogManager.getLogger(FluidContainerTransferManager.class);
    public static final GenericRegisteredSerializer<IFluidContainerTransfer> TRANSFER_LOADERS = new GenericRegisteredSerializer();
    public static final String FOLDER = "mantle/fluid_transfer";
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).registerTypeHierarchyAdapter(IFluidContainerTransfer.class, TRANSFER_LOADERS).setPrettyPrinting().disableHtmlEscaping().create();
    public static final FluidContainerTransferManager INSTANCE = new FluidContainerTransferManager();
    private List<IFluidContainerTransfer> transfers = Collections.emptyList();
    @Nullable
    private Set<class_1792> containerItems = Collections.emptySet();

    private FluidContainerTransferManager() {
        super(GSON, FOLDER);
    }

    protected Set<class_1792> getContainerItems() {
        if (this.containerItems == null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            Consumer<class_1792> consumer = arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0);
            for (IFluidContainerTransfer transfer : this.transfers) {
                transfer.addRepresentativeItems(consumer);
            }
            this.containerItems = builder.build();
        }
        return this.containerItems;
    }

    public void init() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)this);
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> JsonHelper.syncPackets(player, joined, MantleNetwork.INSTANCE, new FluidContainerTransferPacket(this.getContainerItems())));
    }

    @Nullable
    private IFluidContainerTransfer loadFluidTransfer(class_2960 key, JsonObject json) {
        try {
            if (!json.has("fabric:load_conditions") || CraftingHelper.processConditions((JsonArray)class_3518.method_15261((JsonObject)json, (String)"fabric:load_conditions"))) {
                return (IFluidContainerTransfer)GSON.fromJson((JsonElement)json, IFluidContainerTransfer.class);
            }
        }
        catch (JsonSyntaxException e) {
            log.error("Failed to load fluid container transfer info from {}", (Object)key, (Object)e);
        }
        return null;
    }

    protected void apply(Map<class_2960, JsonElement> splashList, class_3300 manager, class_3695 profiler) {
        long time = System.nanoTime();
        this.transfers = splashList.entrySet().stream().map(entry -> this.loadFluidTransfer((class_2960)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject())).filter(Objects::nonNull).toList();
        this.containerItems = null;
        log.info("Loaded {} dynamic modifiers in {} ms", (Object)this.transfers.size(), (Object)Float.valueOf((float)(System.nanoTime() - time) / 1000000.0f));
    }

    public boolean mayHaveTransfer(class_1799 stack) {
        return this.getContainerItems().contains(stack.method_7909());
    }

    @Nullable
    public IFluidContainerTransfer getTransfer(class_1799 stack, FluidStack fluid) {
        for (IFluidContainerTransfer transfer : this.transfers) {
            if (!transfer.matches(stack, fluid)) continue;
            return transfer;
        }
        return null;
    }

    public class_2960 getFabricId() {
        return Mantle.getResource("fluid_container_transfer_manager");
    }

    public void setContainerItems(@Nullable Set<class_1792> containerItems) {
        this.containerItems = containerItems;
    }
}

